package gov.va.med.mhv.health.web.form.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import gov.va.med.mhv.health.dto.HealthHistoryRecordDTO;
import gov.va.med.mhv.health.dto.OtherHealthIssueDTO;
import gov.va.med.mhv.health.enums.LivingEnumeration;
import gov.va.med.mhv.health.enums.RelationshipEnumeration;
import gov.va.med.mhv.health.enums.ModifyRelationshipEnumeration;

public class HealthHistoryRecord extends HealthHistoryRecordDTO {


	private static final long serialVersionUID = 8250950032392636159L;

	private List<String> healthCats = new ArrayList<String>();

	private	List<String> healthIssues = new ArrayList<String>();
	
	private boolean airCategory;

	private boolean allCategory;

	private boolean alcoholCategory;

	private boolean bloodCategory;

	private boolean bodyAchesCategory;

	private boolean cancerCategory;

	private boolean childhoodCategory;

	private boolean diabetesCategory;

	private boolean gallbladerCategory;

	private boolean heartCategory;

	private boolean kidneyCategory;

	private boolean liverCategory;

	private boolean moodCategory;

	private boolean nervousCategory;

	private boolean noseBleedsCategory;

	private boolean painCategory;

	private boolean skinCategory;

	private boolean sleepCategory;

	private boolean smokingCategory;

	private boolean stdCategory;

	private boolean stomachCategory;

	private boolean thyroidCategory;

	private boolean weightCategory;
	
	private LinkedHashSet<String> healthCatsSet= new LinkedHashSet<String>();

	private boolean otherCategory;

	private boolean hntCategory;
	
	private String editRelationshipType="";

		
	public String getEditRelationshipType() {
		return editRelationshipType;
	}


	public void setDefaultRelationshipType(String editRelationshipType) {
		this.editRelationshipType = editRelationshipType;
	}


	public RelationshipEnumeration[] getRelationships() {
		return RelationshipEnumeration.values();
	}
	
	
	public ModifyRelationshipEnumeration[] getRelationshipsModify() {
		return ModifyRelationshipEnumeration.values();
	}

	public String getRelationshipType() {
		if (getRelationship()!=null && !getRelationship().isEmpty()) {
			return RelationshipEnumeration.valueOf(getRelationship()).getDescription();
		}
		else {
			return "";
		}
	

	}


	public void getCheckedCats() {	
	
		if (getAwAsthma()) {
			airCategory=true;
			healthCatsSet.add("airCategory");
		}
		if (getAwOther()) {
			airCategory=true;
			healthCatsSet.add("airCategory");
		}
		if (getAwEmphysema()) {
			airCategory=true;
			healthCatsSet.add("airCategory");
		}
		if (getAwTuberculosis()) {
			airCategory=true;
			healthCatsSet.add("airCategory");
		}
		if (getAwPneumonia()) {
			airCategory=true;
			healthCatsSet.add("airCategory");
		}
		if (getAwCOPD()) {
			airCategory=true;
			healthCatsSet.add("airCategory");
		}
		if (getAwSoB()) {
			airCategory=true;
			healthCatsSet.add("airCategory");
		}
		if (getAwBronchitis()) {
			airCategory=true;
			healthCatsSet.add("airCategory");
		}
	
		if (getAlLupus()) {
			allCategory=true;
			healthCatsSet.add("allCategory");
		}
		if (getAlOther()) {
			allCategory=true;
			healthCatsSet.add("allCategory");
		}
		if (getAlAllergies()) {
			allCategory=true;
			healthCatsSet.add("allCategory");
		}
		if (getAlLupus()) {
			allCategory=true;
			healthCatsSet.add("allCategory");
		}
		if (getAlOther()) {
			allCategory=true;
			healthCatsSet.add("allCategory");
		}
		if (getAlAllergies()) {
			allCategory=true;
			healthCatsSet.add("allCategory");
		}
		
		if (getAlcSixDrinks()) {
			alcoholCategory=true;
			healthCatsSet.add("alcoholCategory");
		}
		if (getAlcSocial()) {
			alcoholCategory=true;
			healthCatsSet.add("alcoholCategory");
		}
		if (getAlcTwoShots()) {
			alcoholCategory=true;
			healthCatsSet.add("alcoholCategory");
		}
		if (getAlcOneDrink()) {
			alcoholCategory=true;
			healthCatsSet.add("alcoholCategory");
		}

		if (getBlClotting()) {
			bloodCategory=true;
			healthCatsSet.add("bloodCategory");
		}
		if (getBlOther()) {
			bloodCategory=true;		
			healthCatsSet.add("bloodCategory");
		}
		if (getBlAnemia()) {
			bloodCategory=true;	
			healthCatsSet.add("bloodCategory");
		}
		if (getBlSickleCell()) {
			bloodCategory=true;
			healthCatsSet.add("bloodCategory");
		}
		if (getBlLeukemia()) {
			bloodCategory=true;	
			healthCatsSet.add("bloodCategory");
		}
		if (getBlBruising()) {
			bloodCategory=true;	
			healthCatsSet.add("bloodCategory");
		}

		if (getBaArthritis()) {
			bodyAchesCategory=true;
			healthCatsSet.add("bodyAchesCategory");
		}
		if (getBaFibromyalgia()) {
			bodyAchesCategory=true;
			healthCatsSet.add("bodyAchesCategory");
		}
		if (getBaJointPain()) {
			bodyAchesCategory=true;
			healthCatsSet.add("bodyAchesCategory");
		}
		if (getBaOther()) {
			bodyAchesCategory=true;
			healthCatsSet.add("bodyAchesCategory");
		}
		if (getBaLymeDisease()) {
			bodyAchesCategory=true;
			healthCatsSet.add("bodyAchesCategory");
		}
		
		if (getCaBreast()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");
		}
		if (getCaLung()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");
		}
		if (getCaOvarian()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");
		}
		if (getCaProstate()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");
		}
		if (getCaStomach()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");
		}
		if (getCaBowel()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");
		}
		if (getCaOther()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");
		}
		if (getCaSkin()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");
		}
		if (getCaColon()) {
			cancerCategory=true;
			healthCatsSet.add("cancerCategory");

		}
		if (getChMeasles()) {
			childhoodCategory=true;
			healthCatsSet.add("childhoodCategory");
		}
		if (getChOther()) {
			childhoodCategory=true;
			healthCatsSet.add("childhoodCategory");
		}
		if (getChDiphtheria()) {
			childhoodCategory=true;
			healthCatsSet.add("childhoodCategory");
		}
		if (getChChickenPox()) {
			childhoodCategory=true;
			healthCatsSet.add("childhoodCategory");
		}
		if (getChWhoopingCough()) {
			childhoodCategory=true;
			healthCatsSet.add("childhoodCategory");
		}
		if (getChMumps()) {
			childhoodCategory=true;
			healthCatsSet.add("childhoodCategory");
		}
		
		if (getDbType3()) {
			diabetesCategory=true;
			healthCatsSet.add("diabetesCategory");
		}
		if (getDbType2()) {
			diabetesCategory=true;
			healthCatsSet.add("diabetesCategory");
		}
		if (getDbType1()) {
			diabetesCategory=true;
			healthCatsSet.add("diabetesCategory");
		}
		
		if (getGbStones()) {
			gallbladerCategory=true;
			healthCatsSet.add("gallbladerCategory");
		}
		if (getGbOther()) {
			gallbladerCategory=true;
			healthCatsSet.add("gallbladerCategory");
		}
		if (getGbDisease()) {
			gallbladerCategory=true;
			healthCatsSet.add("gallbladerCategory");
		}
		
		if (getHntCataracts()) {
			hntCategory=true;
			healthCatsSet.add("hntCategory");
		}
		if (getHntDizziness()) {
			hntCategory=true;
			healthCatsSet.add("hntCategory");
		}
		if (getHntDyslexia()) {
			hntCategory=true;
			healthCatsSet.add("hntCategory");
		}
		if (getHntGlaucoma()) {
			hntCategory=true;
			healthCatsSet.add("hntCategory");
		}
		if (getHntHearingLoss()) {
			hntCategory=true;
			healthCatsSet.add("hntCategory");
		}
		if (getHntMigraineHeadaches()) {
			hntCategory=true;
			healthCatsSet.add("hntCategory");
		}
		if (getHntRetinitisPigmentosa()) {
			hntCategory=true;
			healthCatsSet.add("hntCategory");
		}
		if (getHntOther()) {
			hntCategory=true;
			healthCatsSet.add("hntCategory");
		}
		
		if (getHeHighCholesterol()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeOther()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeAttack()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeRhythmAbnormality()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeStroke()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeMurmur()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeCongestiveFailure()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeHighPressure()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeMitralValveProlapse()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getHeAngina()) {
			heartCategory=true;
			healthCatsSet.add("heartCategory");
		}
		if (getKiInfections()) {
			kidneyCategory=true;
			healthCatsSet.add("kidneyCategory");
		}
		if (getKiOther()) {
			kidneyCategory=true;
			healthCatsSet.add("kidneyCategory");
		}
		if (getKiStones()) {
			kidneyCategory=true;
			healthCatsSet.add("kidneyCategory");
		}
		if (getKiRenalFailure()) {
			kidneyCategory=true;
			healthCatsSet.add("kidneyCategory");
		}
		
		if (getLiCirrhosis()) {
			liverCategory=true;
			healthCatsSet.add("liverCategory");
		}
		if (getLiHepatitisC()) {
			liverCategory=true;
			healthCatsSet.add("liverCategory");
		}
		if (getLiHepatitisB()) {
			liverCategory=true;
			healthCatsSet.add("liverCategory");
		}
		if (getLiHepatitisA()) {
			liverCategory=true;
			healthCatsSet.add("liverCategory");
		}
		if (getLiOther()) {
			liverCategory=true;
			healthCatsSet.add("liverCategory");
		}
		
		if (getMdOther()) {
			moodCategory=true;
			healthCatsSet.add("moodCategory");
		}
		if (getMdBipolar()) {
			moodCategory=true;
			healthCatsSet.add("moodCategory");
		}
		if (getMdPTSD()) {
			moodCategory=true;
			healthCatsSet.add("moodCategory");
		}
		if (getMdAnxiety()) {
			moodCategory=true;
			healthCatsSet.add("moodCategory");
		}
		if (getMdParanoia()) {
			moodCategory=true;
			healthCatsSet.add("moodCategory");
		}
		if (getMdSchizophrenia()) {
			moodCategory=true;
			healthCatsSet.add("moodCategory");
		}
		if (getMdDepression()) {
			moodCategory=true;
			healthCatsSet.add("moodCategory");
		}
		
		if (getNvNumbness()) {
			nervousCategory=true;
			healthCatsSet.add("nervousCategory");
		}
		if (getNvSeizures()) {
			nervousCategory=true;
			healthCatsSet.add("nervousCategory");
		}
		if (getNvEpilepsy()) {
			nervousCategory=true;
			healthCatsSet.add("nervousCategory");
		}
		if (getNvOther()) {
			nervousCategory=true;
			healthCatsSet.add("nervousCategory");
		}
		if (getNvMultipleSclerosis()) {
			nervousCategory=true;
			healthCatsSet.add("nervousCategory");
		}
		if (getNvParalysis()) {
			nervousCategory=true;
			healthCatsSet.add("nervousCategory");
		}
	
		if (getNbOnePerMonth()) {
			noseBleedsCategory=true;
			healthCatsSet.add("noseBleedsCategory");
		}
		if (getNbOnePerDay()) {
			noseBleedsCategory=true;
			healthCatsSet.add("noseBleedsCategory");
		}
		if (getNbOnePerWeek()) {
			noseBleedsCategory=true;
			healthCatsSet.add("noseBleedsCategory");
		}
	
		if (getPnOther()) {
			painCategory=true;
			healthCatsSet.add("painCategory");
		}
		if (getPnJoint()) {
			painCategory=true;
			healthCatsSet.add("painCategory");
		}
		if (getPnLeg()) {
			painCategory=true;
			healthCatsSet.add("painCategory");
		}
		if (getPnMuscle()) {
			painCategory=true;
			healthCatsSet.add("painCategory");
		}
		if (getPnBack()) {
			painCategory=true;
			healthCatsSet.add("painCategory");
		}
		
		if (getSkOther()) {
			skinCategory=true;
			healthCatsSet.add("skinCategory");
		}
		if (getSkEczema()) {
			skinCategory=true;
			healthCatsSet.add("skinCategory");
		}
		if (getSkPsoriasis()) {
			skinCategory=true;
			healthCatsSet.add("skinCategory");
		}
		
		if (getSlOther()) {
			sleepCategory=true;
			healthCatsSet.add("sleepCategory");
		}
		if (getSlApnea()) {
			sleepCategory=true;
			healthCatsSet.add("sleepCategory");
		}
		if (getSlInsomnia()) {
			sleepCategory=true;
			healthCatsSet.add("sleepCategory");
		}
		
		if (getSmOnePackPerDay()) {
			smokingCategory=true;
			healthCatsSet.add("smokingCategory");
		}
		if (getSmTwentyYears()) {
			smokingCategory=true;
			healthCatsSet.add("smokingCategory");
		}
		if (getSmTenYears()) {
			smokingCategory=true;
			healthCatsSet.add("smokingCategory");
		}
		if (getSmCurrent()) {
			smokingCategory=true;
			healthCatsSet.add("smokingCategory");
		}
		
		if (getStdGonorrhea()) {
			stdCategory=true;
			healthCatsSet.add("stdCategory");
		}
		if (getStdSyphilis()) {
			stdCategory=true;
			healthCatsSet.add("stdCategory");
		}
		if (getStdOther()) {
			stdCategory=true;
			healthCatsSet.add("stdCategory");

		}
		if (getStdHerpes()) {
			stdCategory=true;
			healthCatsSet.add("stdCategory");
		}
		if (getStdChlamydia()) {
			stdCategory=true;
			healthCatsSet.add("stdCategory");
		}
		if (getStmNausea()) {
			stomachCategory=true;	
			healthCatsSet.add("stdCategory");
		}
	
		if (getStmSevereIndigestion()) {
			stomachCategory=true;
			healthCatsSet.add("stomachCategory");
		}
		if (getStmPain()) {
			stomachCategory=true;
			healthCatsSet.add("stomachCategory");
		}
		if (getStmIBS()) {
			stomachCategory=true;
			healthCatsSet.add("stomachCategory");
		}
		if (getStmUlcers()) {
			stomachCategory=true;
			healthCatsSet.add("stomachCategory");
		}
		if (getStmOther()) {
			stomachCategory=true;
			healthCatsSet.add("stomachCategory");
		}
		
		if (getThOther()) {
			thyroidCategory=true;
			healthCatsSet.add("thyroidCategory");
		}
		if (getThTumor()) {
			thyroidCategory=true;
			healthCatsSet.add("thyroidCategory");
		}
		if (getThGoiter()) {
			thyroidCategory=true;
			healthCatsSet.add("thyroidCategory");
		}
		if (getWtOverweight()) {
			weightCategory=true;
			healthCatsSet.add("weightCategory");
		}
		if (getWtUnderweight()) {
			weightCategory=true;
			healthCatsSet.add("weightCategory");
		}
		
		if(getOtherHealthIssues().size() >0) {
			otherCategory=true;
			healthCatsSet.add("otherCategory");
			
		}
	}

	public ArrayList<String> getDisplayHealthIssues() {
		ArrayList<String> allCategoryIssueList = new ArrayList<String>();
		
		getCheckedCats();
		
		ArrayList<String> allCategoryList = buildAllCategoryItems();
		allCategoryIssueList.addAll(allCategoryList);
		
		ArrayList<String> alcCategoryList = buildAlcCategoryItems();
		allCategoryIssueList.addAll(alcCategoryList);
	
		ArrayList<String> airCategoryList =buildAirCategoryItems();
		allCategoryIssueList.addAll(airCategoryList);
		
		ArrayList<String> baCategoryList = buildBaCategoryItems();
		allCategoryIssueList.addAll(baCategoryList);
		
		ArrayList<String> blCategoryList = buildBlCategoryItems();
		allCategoryIssueList.addAll(blCategoryList);

		ArrayList<String> caCategoryList = buildCaCategoryItems();
		allCategoryIssueList.addAll(caCategoryList);
		
		ArrayList<String> chCategoryList = buildChCategoryItems();
		allCategoryIssueList.addAll(chCategoryList);
		
		ArrayList<String> dbCategoryList = buildDbCategoryItems();
		allCategoryIssueList.addAll(dbCategoryList);
		
		ArrayList<String> gbCategoryList = buildGbCategoryItems();
		allCategoryIssueList.addAll(gbCategoryList);
		
		ArrayList<String> heCategoryList = buildHeCategoryItems();
		allCategoryIssueList.addAll(heCategoryList);
		
		ArrayList<String> hntCategoryList = buildHntCategoryItems();
		allCategoryIssueList.addAll(hntCategoryList);
		
		ArrayList<String> kiCategoryList = buildKiCategoryItems();
		allCategoryIssueList.addAll(kiCategoryList);

		ArrayList<String> liCategoryList = buildLiCategoryItems();
		allCategoryIssueList.addAll(liCategoryList);

		ArrayList<String> mdCategoryList = buildMdCategoryItems();
		allCategoryIssueList.addAll(mdCategoryList);
		
		ArrayList<String> nbCategoryList = buildNbCategoryItems();
		allCategoryIssueList.addAll(nbCategoryList);

		ArrayList<String> nvCategoryList = buildNvCategoryItems();
		allCategoryIssueList.addAll(nvCategoryList);
		
		ArrayList<String> pnCategoryList = buildPnCategoryItems();
		allCategoryIssueList.addAll(pnCategoryList);
		
		ArrayList<String> skCategoryList = buildSkCategoryItems();
		allCategoryIssueList.addAll(skCategoryList);
		
		ArrayList<String> slCategoryList = buildSlCategoryItems();
		allCategoryIssueList.addAll(slCategoryList);
		
		ArrayList<String> smCategoryList = buildSmCategoryItems();
		allCategoryIssueList.addAll(smCategoryList);

		ArrayList<String> stdCategoryList = buildStdCategoryItems();
		allCategoryIssueList.addAll(stdCategoryList);

		ArrayList<String> stmCategoryList = buildStmCategoryItems();
		allCategoryIssueList.addAll(stmCategoryList);

		ArrayList<String> thCategoryList = buildThCategoryItems();
		allCategoryIssueList.addAll(thCategoryList);

		ArrayList<String> wtCategoryList = buildWtCategoryItems(thCategoryList);
		allCategoryIssueList.addAll(wtCategoryList);

		
		for (OtherHealthIssueDTO dto: getOtherHealthIssues()) {
			allCategoryIssueList.add(dto.getIssue());
		}
		
		return allCategoryIssueList;
	}

	private ArrayList<String> buildWtCategoryItems( ArrayList<String> thCategoryList) {
		ArrayList<String> wtCategoryList = new ArrayList<String>();

		
		if (getWtOverweight()) {
			wtCategoryList.add("Overweight");
		}
		if (getWtUnderweight()) {
			wtCategoryList.add("Underweight");
		}
		return wtCategoryList;
	}

	private ArrayList<String> buildThCategoryItems() {
		ArrayList<String> thCategoryList = new ArrayList<String>();
		
		if (getThGoiter()) {
			thCategoryList.add("Goiter");
		}
		
		if (getThTumor()) {
			thCategoryList.add("Thyroid: Tumor");
		}
		if (getThOther()) {
			thCategoryList.add("Thyroid: Other");
		}
		return thCategoryList;
	}

	private ArrayList<String> buildStmCategoryItems() {
		ArrayList<String> stmCategoryList = new ArrayList<String>();

		if (getStmNausea()) {
			stmCategoryList.add("Nausea");
		}
		if (getStmSevereIndigestion()) {
			stmCategoryList.add("Severe Indigestion");
		}
		if (getStmPain()) {
			stmCategoryList.add("Stomach/Bowel Pain");
		}
		if (getStmIBS()) {
			stmCategoryList.add("Irritable Bowel Syndrome");
		}
		if (getStmUlcers()) {
			stmCategoryList.add("Ulcers");
		}
		
		Collections.sort(stmCategoryList);
		
		if (getStmOther()) {
			stmCategoryList.add("Stomach/Bowel: Other");
		}
		return stmCategoryList;
	}

	private ArrayList<String> buildStdCategoryItems() {
		ArrayList<String> stdCategoryList = new ArrayList<String>();

		if (getStdGonorrhea()) {
			stdCategoryList.add("Gonorrhea");
		}
		if (getStdSyphilis()) {
			stdCategoryList.add("Syphilis");
		}
	
		if (getStdHerpes()) {
			stdCategoryList.add("Herpes");
		}
		if (getStdChlamydia()) {
			stdCategoryList.add("Chlamydia");
		}
		
		Collections.sort(stdCategoryList);
		
		if (getStdOther()) {
			stdCategoryList.add("Sexually Transmitted Diseases: Other");
		}
		return stdCategoryList;
	}

	private ArrayList<String> buildSmCategoryItems() {
		ArrayList<String> smCategoryList = new ArrayList<String>();
		
		if (healthCatsSet.contains("smokingCategory")) {
			int itemCount=0;
			
			String smokingItem="Smoking History: ";
			
			
			if (getSmCurrent()) {
				itemCount++;
			}
			if (getSmOnePackPerDay()) {
				itemCount++;
			}
			if (getSmTenYears()) {
				itemCount++;
			}
			if (getSmTwentyYears()) {
				itemCount++;
			}
			
			int checkedCount=0;
			
			
			if (getSmCurrent()) {
				checkedCount++;
				smokingItem+=("Current");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					smokingItem+=", ";
				}
			}
			if (getSmOnePackPerDay()) {
				checkedCount++;
				smokingItem+=(">1 pack/day");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					smokingItem+=", ";
				}
			}
			if (getSmTenYears()) {
				checkedCount++;
				smokingItem+=(">10 Years");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					smokingItem+=", ";
				}
			}
			if (getSmTwentyYears()) {
				checkedCount++;
				smokingItem+=(">20 Years");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					smokingItem+=", ";
				}
			}
			smCategoryList.add(smokingItem);
		}
		return smCategoryList;
	}

	private ArrayList<String> buildSlCategoryItems() {
		ArrayList<String> slCategoryList = new ArrayList<String>();
		
		if (getSlApnea()) {
			slCategoryList.add("Sleep Apnea");
		}
		if (getSlInsomnia()) {
			slCategoryList.add("Insomnia");
		}
		if (getSlOther()) {
			slCategoryList.add("Sleep Disorders: Other");
		}
		return slCategoryList;
	}

	private ArrayList<String> buildSkCategoryItems() {
		ArrayList<String> skCategoryList = new ArrayList<String>();
		if (getSkEczema()) {
			skCategoryList.add("Eczema");
		}
		if (getSkPsoriasis()) {
			skCategoryList.add("Psoriasis");
		}
		if (getSkOther()) {
			skCategoryList.add("Skin Disorders: Other");
		}
		return skCategoryList;
	}

	private ArrayList<String> buildPnCategoryItems() {
		ArrayList<String> pnCategoryList = new ArrayList<String>();

		if (healthCatsSet.contains("painCategory")) {
			int itemCount=0;
			String painItem="Pain: ";
			
			if (getPnBack()) {
				itemCount++;
			}
			if (getPnJoint()) {
				itemCount++;
			}
			if (getPnLeg()) {
				itemCount++;
			}
			if (getPnMuscle()) {
				itemCount++;
			}
			if (getPnOther()) {
				itemCount++;
			}
			
			int checkedCount=0;
			
			
			if (getPnBack()) {
				checkedCount++;
				painItem+=("Back");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					painItem+=", ";
				}	
			}
			if (getPnJoint()) {
				checkedCount++;
				painItem+=("Joint");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					painItem+=", ";
				}	
			}
			
			if (getPnLeg()) {
				checkedCount++;
				painItem+=("Leg pain walking long distances");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					painItem+=", ";
				}				
			}
			
			if (getPnMuscle()) {
				checkedCount++;
				painItem+=("Muscle");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					painItem+=", ";
				}	
			}
			
		
			if (getPnOther()) {
				checkedCount++;
				painItem+=("Other");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					painItem+=", ";
				}	
			}
			pnCategoryList.add(painItem);
		}
		return pnCategoryList;
	}

	private ArrayList<String> buildNbCategoryItems() {
		ArrayList<String> nbCategoryList = new ArrayList<String>();
	
		if (healthCatsSet.contains("noseBleedsCategory")) {
			
			int itemCount=0;
			
			String nbItem="Nose Bleeds: ";
			
			if (getNbOnePerMonth()) {
				itemCount++;
			}
			if (getNbOnePerWeek()) {
				itemCount++;
			}
			if (getNbOnePerDay()) {
				itemCount++;
			}
			
			int checkedCount=0;
			
			if (getNbOnePerMonth()) {
				checkedCount++;
				nbItem+=(">1/month");
				if (itemCount > 1 && checkedCount < itemCount ) {
					nbItem+=", ";
				}	
			}
			if (getNbOnePerWeek()) {
				checkedCount++;
				nbItem+=(">1/week");
				if (itemCount > 1 && checkedCount < itemCount ) {
					nbItem+=", ";
				}	
			}
			
			if (getNbOnePerDay()) {
				checkedCount++;
				nbItem+=(">1/day");
				if (itemCount > 1 && checkedCount < itemCount ) {
					nbItem+=", ";
				}	
			}
			
			nbCategoryList.add(nbItem);
		}
		return nbCategoryList;
	}

	private ArrayList<String> buildNvCategoryItems() {
		ArrayList<String> nvCategoryList = new ArrayList<String>();
	
		if (getNvNumbness()) {
			nvCategoryList.add("Numbness");
		}
		if (getNvSeizures()) {
			nvCategoryList.add("Seizures (Not Epilepsy)");
		}
		if (getNvEpilepsy()) {
			nvCategoryList.add("Epilepsy");
		}
	
		if (getNvMultipleSclerosis()) {
			nvCategoryList.add("Multiple Sclerosis");
		}
		if (getNvParalysis()) {
			nvCategoryList.add("Paralysis");
		}
		
		Collections.sort(nvCategoryList);
		
		if (getNvOther()) {
			nvCategoryList.add("Nervous System: Other");
		}
		return nvCategoryList;
	}

	private ArrayList<String> buildMdCategoryItems() {
		ArrayList<String> mdCategoryList = new ArrayList<String>();

		if (getMdBipolar()) {
			mdCategoryList.add("Bipolar");
		}
		if (getMdPTSD()) {
			mdCategoryList.add("PTSD");
		}
		if (getMdAnxiety()) {
			mdCategoryList.add("Anxiety");
		}
		if (getMdParanoia()) {
			mdCategoryList.add("Paranoia");
		}
		if (getMdSchizophrenia()) {
			mdCategoryList.add("Schizophrenia");
		}
		if (getMdDepression()) {
			mdCategoryList.add("Depression");
		}
		
		Collections.sort(mdCategoryList);
		
		if (getMdOther()) {
			mdCategoryList.add("Mood or Cognitive Disorders: Other");
		}
		return mdCategoryList;
	}

	private ArrayList<String> buildLiCategoryItems() {
		ArrayList<String> liCategoryList = new ArrayList<String>();

		if (getLiCirrhosis()) {
			liCategoryList.add("Cirrhosis");
		}		
		if (getLiHepatitisA()) {
			liCategoryList.add("Hepatitis A");
		}
		
		if (getLiHepatitisB()) {
			liCategoryList.add("Hepatitis B");
		}
		
		if (getLiHepatitisC()) {
			liCategoryList.add("Hepatitis C");
		}
		if (getLiOther()) {
			liCategoryList.add("Liver: Other");
		}
		return liCategoryList;
	}

	private ArrayList<String> buildKiCategoryItems() {
		ArrayList<String> kiCategoryList = new ArrayList<String>();

		if (getKiInfections()) {
			kiCategoryList.add("Kidney Infections");
		}
		if (getKiRenalFailure()) {
			kiCategoryList.add("Renal Failure");
		}
		if (getKiStones()) {
			kiCategoryList.add("Kidney Stones");
		}		
		if (getKiOther()) {
			kiCategoryList.add("Kidney: Other");
		}
		return kiCategoryList;
	}

	private ArrayList<String> buildHeCategoryItems() {
		ArrayList<String> heCategoryList = new ArrayList<String>();
		
		if (getHeAngina()) {
			heCategoryList.add("Angina (Pain)");
		}
		if (getHeAttack()) {
			heCategoryList.add("Heart Attack");
		}
		if (getHeCongestiveFailure()) {
			heCategoryList.add("Congestive Heart Failure");
		}
		if (getHeHighCholesterol()) {
			heCategoryList.add("High Blood Cholesterol");
		}
		if (getHeHighPressure()) {
			heCategoryList.add("High Blood Pressure");
		}
		if (getHeMitralValveProlapse()) {
			heCategoryList.add("Mitral Valve Prolapse");
		}
		if (getHeMurmur()) {
			heCategoryList.add("Heart Murmur");
		}
		if (getHeRhythmAbnormality()) {
			heCategoryList.add("Rhythm Abnormalities");
		}
		if (getHeStroke()) {
			heCategoryList.add("Stroke");
		}
		if (getHeOther()) {
			heCategoryList.add("Heart/Cardiovascular: Other");
		}
		return heCategoryList;
	}

	private ArrayList<String> buildGbCategoryItems() {
		ArrayList<String> gbCategoryList = new ArrayList<String>();
		
		if (getGbDisease()) {
			gbCategoryList.add("Gallbladder Disease");
		}
		if (getGbStones()) {
			gbCategoryList.add("Gallstones");
		}	
		if (getGbOther()) {
			gbCategoryList.add("Other Gallbladder Issues");
		}
		return gbCategoryList;
	}
	
	private ArrayList<String> buildHntCategoryItems() {
		ArrayList<String> hntCategoryList = new ArrayList<String>();
		
		if (getHntCataracts()) {
			hntCategoryList.add("Cataracts");
		}
		if (getHntDizziness()) {
			hntCategoryList.add("Dizziness");
		}
		if (getHntDyslexia()) {
			hntCategoryList.add("Dyslexia");
		}
		if (getHntGlaucoma()) {
			hntCategoryList.add("Glaucoma");
		}
		if (getHntHearingLoss()) {
			hntCategoryList.add("Hearing Loss");
		}
		if (getHntMigraineHeadaches()) {
			hntCategoryList.add("Migraine Headaches");
		}
		if (getHntRetinitisPigmentosa()) {
			hntCategoryList.add("Retinitis Pigmentosa");
		}
		
		Collections.sort(hntCategoryList);
		
		if (getHntOther()) {
			hntCategory=true;
			hntCategoryList.add("Head, Eyes, Ears, Nose, Throat: Other");
		}
		
		
		
		
		return hntCategoryList;
	}
	
	

	private ArrayList<String> buildDbCategoryItems() {
		ArrayList<String> dbCategoryList = new ArrayList<String>();

		if (getDbType1()) {
			dbCategoryList.add("Type 1 Diabetes");
		}
		
		if (getDbType2()) {
			dbCategoryList.add("Type 2 Diabetes");
		}
	
		if (getDbType3()) {
			dbCategoryList.add("Type 3 Diabetes");
		}
		return dbCategoryList;
	}

	private ArrayList<String> buildChCategoryItems() {
		ArrayList<String> chCategoryList = new ArrayList<String>();

		if (getChMeasles()) {
			chCategoryList.add("Measles");
		}
		if (getChDiphtheria()) {
			chCategoryList.add("Diphtheria");
		}
		if (getChChickenPox()) {
			chCategoryList.add("Chicken Pox");
		}
		if (getChWhoopingCough()) {
			chCategoryList.add("Whooping Cough");
		}
		if (getChMumps()) {
			chCategoryList.add("Mumps");
		}
		
		Collections.sort(chCategoryList);
		
		if (getChOther()) {
			chCategoryList.add("Childhood Diseases: Other");
		}
		return chCategoryList;
	}

	private ArrayList<String> buildCaCategoryItems() {
		ArrayList<String> caCategoryList = new ArrayList<String>();
		
		if (getCaBreast()) {
			caCategoryList.add("Breast Cancer");
		}
		if (getCaLung()) {
			caCategoryList.add("Lung Cancer");
		}
		if (getCaOvarian()) {
			caCategoryList.add("Ovarian Cancer");
		}
		if (getCaProstate()) {
			caCategoryList.add("Prostate Cancer");
		}
		if (getCaStomach()) {
			caCategoryList.add("Stomach Cancer");
		}
		if (getCaBowel()) {
			caCategoryList.add("Bowel Cancer");
		}
		if (getCaSkin()) {
			caCategoryList.add("Skin Cancer");
		}
		if (getCaColon()) {
			caCategoryList.add("Colon Camcer");
		}
		
		Collections.sort(caCategoryList);
		
		if (getCaOther()) {
			caCategoryList.add("Other Cancer");
		}
		return caCategoryList;
	}

	private ArrayList<String> buildBaCategoryItems() {
		ArrayList<String> baCategoryList = new ArrayList<String>();

		if (getBaArthritis()) {
			baCategoryList.add("Arthritis");
		}
		if (getBaFibromyalgia()) {
			baCategoryList.add("Fibromyalgia");
		}
		if (getBaJointPain()) {
			baCategoryList.add("Joint Pain");
		}
		if (getBaLymeDisease()) {
			baCategoryList.add("Lyme Disease");
		}
		
		Collections.sort(baCategoryList);
		
		if (getBaOther()) {
			baCategoryList.add("Body Aches and Pains: Other");
		}
		return baCategoryList;
	}

	private ArrayList<String> buildBlCategoryItems() {
		ArrayList<String> blCategoryList = new ArrayList<String>();

		if (getBlClotting()) {
			blCategoryList.add("Clotting");
		}
		if (getBlAnemia()) {
			blCategoryList.add("Anemia");
		}
		if (getBlSickleCell()) {
			blCategoryList.add("Sickle Cell Anemia");
		}
		if (getBlLeukemia()) {
			blCategoryList.add("Leukemia");
		}
		if (getBlBruising()) {
			blCategoryList.add("Bruising");
		}
		Collections.sort(blCategoryList);
		if (getBlOther()) {
			blCategoryList.add("Blood Disorders: Other");
		}
		return blCategoryList;
	}

	private ArrayList<String> buildAllCategoryItems() {
		ArrayList<String> allCategoryList = new ArrayList<String>();
		
		if (getAlAllergies()) {
			allCategoryList.add("Allergies");

		}
		if (getAlLupus()) {
			allCategoryList.add("Lupus");
		}
		if (getAlOther()) {
			allCategoryList.add("Other Allergies and Immune System Issues");

		}
		return allCategoryList;
	}

	private ArrayList<String> buildAirCategoryItems() {
		ArrayList<String> airCategoryList = new ArrayList<String>();
		if (getAwAsthma()) {
			airCategoryList.add("Asthma");
		}
		if (getAwBronchitis()) {
			airCategoryList.add("Bronchitis");
		}
		if (getAwCOPD()) {
			airCategoryList.add("COPD");
		}
		if (getAwEmphysema()) {
			airCategoryList.add("Emphysema");
		}
		if (getAwPneumonia()) {
			airCategoryList.add("Pneumonia");
		}
		if (getAwSoB()) {
			airCategoryList.add("Shortness of Breath");
		}
		if (getAwTuberculosis()) {
			airCategoryList.add("Tuberculosis");
		}
		
		Collections.sort(airCategoryList);
		
		if (getAwOther()) {
			airCategoryList.add("Other Airway and Breathing System Issues");
		}
		return airCategoryList;
	}

	private ArrayList<String> buildAlcCategoryItems() {
		ArrayList<String> alcCategoryList = new ArrayList<String>();
		
		if (healthCatsSet.contains("alcoholCategory")) {
			int itemCount=0;
			
			String alcoholItem="Alcohol History: ";
			
			if (getAlcSocial()) {
				itemCount++;
			}
			if (getAlcOneDrink()) {
				itemCount++;
			}
			if (getAlcSixDrinks()) {
				itemCount++;

			}
			if (getAlcTwoShots()) {
				itemCount++;
			}
			
			int checkedCount=0;
			
			if (getAlcSocial()) {
				checkedCount++;
				alcoholItem+=("Social");	
				if (itemCount >=1 && checkedCount < itemCount ) {
					alcoholItem+=", ";
				}	
			}
			if (getAlcOneDrink()) {
				checkedCount++;
				alcoholItem+=("1 beer/wine a day");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					alcoholItem+=", ";
				}	
				
			}
			if (getAlcSixDrinks()) {
				checkedCount++;
				alcoholItem+=(">6 beers/wines a day");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					alcoholItem+=", ";
				}	
				
				
			}
			if (getAlcTwoShots()) {
				checkedCount++;
				alcoholItem+=(">2 shots a day");
				if (itemCount >= 1 && checkedCount < itemCount ) {
					alcoholItem+=", ";
				}		
			}
			
			alcCategoryList.add(alcoholItem);
			
		}
		return alcCategoryList;
	}
	
	public String getDisplayHealthCats() {
		String healthCatsDisplay = "";
		getCheckedCats();
		
		boolean isFirst=true;

		String firstCategory = "";
		String lastCategory ="";
		boolean isCommaSkipped=false;
		
		if (healthCatsSet!=null) {
			
			for (String healthCat: healthCatsSet) {
				if (isFirst) {
					firstCategory=healthCat;
					isFirst=false;
				}
				
				lastCategory=healthCat;
				
			}
			

			if (airCategory) {
				healthCatsDisplay += "Airway and Breathing System Issues";
				
				if (lastCategory.equals("airCategory")) {
					isCommaSkipped=true;
				}

				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (allCategory) {
				healthCatsDisplay += "Allergies and Immune System Issues";

				if (lastCategory.equals("allCategory")) {
					isCommaSkipped=true;
				}
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (alcoholCategory) {
				healthCatsDisplay += "Alcohol History";

				if (lastCategory.equals("alcoholCategory")) {
					isCommaSkipped=true;
				}
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (bloodCategory) {
				healthCatsDisplay += "Blood Disorders";
				
				if (lastCategory.equals("bloodCategory")) {
					isCommaSkipped=true;
				}

				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (bodyAchesCategory) {
				healthCatsDisplay += "Body Aches and Pains";
				
				if (lastCategory.equals("bodyAchesCategory")) {
					isCommaSkipped=true;
				}
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (cancerCategory) {
				healthCatsDisplay += "Cancer";
				
				if (lastCategory.equals("cancerCategory")) {
					isCommaSkipped=true;
				}

				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (childhoodCategory) {
				healthCatsDisplay += "Childhood Diseases";
				
				if (lastCategory.equals("childhoodCategory")) {
					isCommaSkipped=true;
				}
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (diabetesCategory) {
				healthCatsDisplay += "Diabetes";
				
				if (lastCategory.equals("diabetesCategory")) {
					isCommaSkipped=true;
				}
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (gallbladerCategory) {
				healthCatsDisplay += "Gallblader Issues";
				

				if (lastCategory.equals("gallbladerCategory")) {
					isCommaSkipped=true;
				}		
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}
			}
			
			
			if (hntCategory) {
				healthCatsDisplay += "Head, Eyes, Ears, Nose, Throat Issues";
				

				if (lastCategory.equals("hntCategory")) {
					isCommaSkipped=true;
				}		
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}
			
			if (heartCategory) {
				healthCatsDisplay += "Heart/Cardiovascular Issues";
				
				if (lastCategory.equals("heartCategory")) {
					isCommaSkipped=true;
				}		
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (kidneyCategory) {
				healthCatsDisplay += "Kidney Issues";
						
				if (lastCategory.equals("kidneyCategory")) {
					isCommaSkipped=true;
				}				
						
			
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (liverCategory) {
				healthCatsDisplay += "Liver Issues";
				
				if (lastCategory.equals("liverCategory")) {
					isCommaSkipped=true;
				}			
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (moodCategory) {
				healthCatsDisplay += "Mood or Cognitive Disorders";
				
				if (lastCategory.equals("moodCategory")) {
					isCommaSkipped=true;
				}			
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (nervousCategory) {
				healthCatsDisplay += "Nervous System Issues";
				
				if (lastCategory.equals("nervousCategory")) {
					isCommaSkipped=true;
				}		
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (noseBleedsCategory) {
				healthCatsDisplay += "Nose Bleeds";
				
				if (lastCategory.equals("noseBleedsCategory")) {
					isCommaSkipped=true;
				}		
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (painCategory) {
				healthCatsDisplay += "Pain Issues";
				
				if (lastCategory.equals("painCategory")) {
					isCommaSkipped=true;
				}	
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (skinCategory) {
				healthCatsDisplay += "Skin Disorders";
				
				if (lastCategory.equals("skinCategory")) {
					isCommaSkipped=true;
				}	
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (sleepCategory) {
				healthCatsDisplay += "Sleep Disorders";
				
				if (lastCategory.equals("sleepCategory")) {
					isCommaSkipped=true;
				}	
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (smokingCategory) {
				healthCatsDisplay += "Smoking History";
				
				
				if (lastCategory.equals("smokingCategory")) {
					isCommaSkipped=true;
				}	
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (stdCategory) {
				healthCatsDisplay += "Sexually Transmitted Diseases";
				
				
				if (lastCategory.equals("stdCategory")) {
					isCommaSkipped=true;
				}	
				
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (stomachCategory) {
				healthCatsDisplay += "Stomach/Bowel Issues";
				
				if (lastCategory.equals("stomachCategory")) {
					isCommaSkipped=true;
				}	
				
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (thyroidCategory) {
				healthCatsDisplay += "Thyroid Issues";
				
				
				if (lastCategory.equals("thyroidCategory")) {
					isCommaSkipped=true;
				}	
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}

			if (weightCategory) {
				healthCatsDisplay += "Weight Issues";
				
				
				if (lastCategory.equals("weightCategory")) {
					isCommaSkipped=true;
				}	
				
				if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
					healthCatsDisplay += ", ";
				}

			}
		}
		
		if (otherCategory) {
			healthCatsDisplay += "Other Health Issues";
			
			
			if (lastCategory.equals("otherCategory")) {
				isCommaSkipped=true;
			}	
			
			if (isCommaPrinted(firstCategory, lastCategory, isCommaSkipped)) {
				healthCatsDisplay += ", ";
			}

		}
		
		
		
		
		return healthCatsDisplay;

	}

	private boolean isCommaPrinted(String firstCategory, String lastCategory, boolean isLastCategorySkipped) {
		boolean doWePrintComma=false;
		if (firstCategory.equals(lastCategory) || isLastCategorySkipped) {
			doWePrintComma=false;
		}
		else {
			doWePrintComma=true;
		}
		return doWePrintComma;
	}
	

	

	public String getLivingStatus() {
		String livingStatus = "";
		if (getLiving()) {
			livingStatus = LivingEnumeration.valueOf("LIVING").getDescription();

		} else {
			livingStatus = LivingEnumeration.valueOf("DECEASED")
					.getDescription();
		}

		return livingStatus;
	}

	public List<String> getHealthIssues() {
		return healthIssues;
	}
}
